<?php

namespace App\Models\AdminDashboard\School;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Week;
use App\Traits\CascadeSoftDeletes;

class SchoolSemester extends Model
{
    use SoftDeletes,CascadeSoftDeletes;

    protected $table='semesters';
    protected $cascadeDeletes = ['vacations'];

    public function weeks()
    {
        return $this->hasMany(Week::class);
    }

    public function vacations()
    {
        return $this->hasMany(SchoolSemesterVacation::class,'semester_id');
    }

}
