<?php

namespace App\Models\AdminDashboard\Procedures\LateProcedure;

use App\Models\Namazeg;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes; 
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\AdminDashboard\Procedures\AbsenceProcedure\ProcedureName;

class LateProcedure extends Model
{
    use HasFactory;  use SoftDeletes;

    protected $table = 'late_procedures';

    protected $guarded= [];

    public function lateForms()
    {
        return $this->belongsToMany(Namazeg::class, 'late_forms', 'late_procedure_id', 'late_form_id')->withTimestamps();
    }

    
    public function procedureName()
    {

        return $this->belongsTo(ProcedureName::class,'name_id');
    }
    
}
