<?php

namespace App\Models\AdminDashboard\Category;

use App\Models\Video;
use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{
    use HasFactory, SoftDeletes, CascadeSoftDeletes;

    protected $table = 'categories';

    protected $guarded =  [];
    protected $cascadeDeletes = ['videos'];

    public function subCategories()
    {
        return $this->hasMany(Category::class, 'parent_id', 'id');
    }
    public function videos()
    {
        return $this->hasMany(Video::class);
    }
}
