<?php

namespace App\Http\Resources\Violation;
use App\Models\Violation;
use App\Models\GradeViolation;
use App\Models\Namazeg;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;
use App\Http\Resources\Violation\ViolationTitleUpdateRequest;

use App\Http\Resources\Violation\ViolationTypeResource;


class ViolationTitleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $violation_id = GradeViolation::where('id', $this->violation_grade_id)->value('violation_id');
        return [
            'id'=>$this->id,
            'name'=>$this->violation_name->name,
            'name_id'=>$this->name,
            'types'=>ViolationTypeResource::collection($this->types),
            'punishment_ids'=>$this->punishments->pluck('violation_punishment_id'),
            'punishment_options'=> NamazegResource::collection(Namazeg::where('type','violations')->get()),
            'violation_grade_id'=>$this->violation_grade_id,
        ];
    }
}
