<?php

namespace App\Http\Resources\User;

use App\Http\Resources\School\SchoolResource;
use App\Models\AdminDashboard\School\School;
use App\Models\User;

use Illuminate\Http\Resources\Json\JsonResource;
class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        $user= User::find($this->id);
        $roles = $user->getRoleNames();
        $userTypes=  explode(',', $this->user_type);

        $userSchools = SchoolResource::collection(School::where('user_id',$this->id)->get());
        $data=[
            'user_id'=>$this->id,
            'name' =>$this->name,
            'email'=>$this->email,
            'phone'=>$this->phone,
            'image'=>($this->image)?public_path('/users/'.$this->image):'image not foud !',
            'phone' =>$this->phone,
            'status'=>$this->status,
            'user_type'=>$userTypes,
            'roles'=>$roles,
        ];

    
        $data['userSchools']=$userSchools;
        
        return $data;
    }
}
