<?php

namespace App\Http\Resources\User;
use Spatie\Permission\Models\Role;
use App\Http\Resources\User\PermissionResource;

use Illuminate\Http\Resources\Json\JsonResource;

class RoleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');

        $role = Role::find($this->id);
        $rolePermissions= PermissionResource::collection($role->permissions()->get());

        return [
            'id'=>$this->id,
            'name' =>$this->name,
            'rolePermissions'=>$rolePermissions,
            'created_at'=>$this->created_at
        ];
    }
}
