<?php

namespace App\Http\Resources\User;
use Spatie\Permission\Models\Permission;
use App\Http\Resources\User\PermissionResource;

use Illuminate\Http\Resources\Json\JsonResource;

class PermissionGroupResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');        
        $permissions = PermissionResource::collection(Permission::where('permission_group_id',$this->id)->get());
        return [
            'id'=>$this->id,
            'name' =>$this->name,
            'permissions'=>$permissions,
        ];
    }
}
