<?php
namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class TrashedRecordResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'model' => $this->model,
            'record_id' => $this->record_id,
            'deleted_at' => $this->deleted_at instanceof Carbon ? $this->deleted_at->toDateTimeString() : $this->deleted_at,        ];
    }
}
