<?php

namespace App\Http\Resources\Slider;
use App\Helpers\Helper;
use App\Models\Slider;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class SliderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
         return [
            'id' => $this->id,
            'text' => $this->text,
            'start_date_type' => __("api.{$this->start_date_type}"),
            'start_date' => Carbon::createFromFormat('d/m/Y', $this->start_date)->format('d/m/Y'),
            'start_date_options' => Helper::getDateOptions($this->start_date, $this->type),
            'end_date_type' => __("api.{$this->end_date_type}"),
            'end_date' => Carbon::createFromFormat('d/m/Y', $this->end_date)->format('d/m/Y'),
            'end_date_options' => Helper::getDateOptions($this->end_date, $this->type),
            'image' => Helper::uploadedImagesPath('sliders', $this->image),
        ];
    }
}
