<?php

namespace App\Http\Resources\School;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;
class SchoolSemesterVacationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');   
        return [
            'id'=>$this->id,
            // 'semester_id'=>$this->semester_id,
            // 'semester_name'=>$this->semester->name,
            'date' => $this->date,
            'date_type' =>(isset($this->date_type)) ? trans('api.'.$this->date_type) : '',
            'date_options'=> Helper::getDateOptions($this->date, $this->date_type),
            'day' => $this->day,
            'week_number'=>$this->week_number,
            'status'=>($this->status == 1)?trans('api.active'):trans('api.inactive'),
        ];
    }
}
