<?php

namespace App\Http\Resources\School;
use Illuminate\Http\Resources\Json\JsonResource;

class SchoolEmployeeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=> $this->id, 
            'name'=> $this->name, 
            'ssn'=> $this->ssn, 
            'phone'=> $this->phone, 
            'email'=> $this->email, 
            'current_work'=> $this->currentWork?->job_title,
            'specialization'=> $this->specialization?->title,
        ];
    }
}
