<?php

namespace App\Http\Resources\School;

use Illuminate\Http\Resources\Json\JsonResource;

class ClassNameResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=>$this->id,
            'grade'=> $this->grade?->name,
            'name'=> $this->name,
            'category'=> $this->category,
        ];
    }
}
