<?php

namespace App\Http\Resources\ManagerDashboard\TeacherSchedule;

use App\Http\Resources\ManagerDashboard\TeacherSchedule\TeacherScheduleDataResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class TeacherScheduleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'teacher_schedule_id'=>$this->id,
            'semester_id'=>$this->semester_id,
            'semester'=>$this->semester->name,
            'created_at' => $this->created_at->format('Y/m/d'),
        ];
    }
}
