<?php

namespace App\Http\Resources\ManagerDashboard\Tables\ShiftSchedule;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ShiftScheduleWeekResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'tilte'=>'جدول المناوبة الأسبوعي',
            'semester_name'=>$this->semester?->name,
            'week'=>$this->week?->name,
            'created_at'=>Carbon::parse($this->created_at)->format('d/m/Y'),
        ];
    }
}
