<?php

namespace App\Http\Resources\ManagerDashboard\Tables\ClassRoomVisits;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ClassroomVisitResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'visiting_teacher' => $this->visitingTeacher->name,
            'visited_teacher' => $this->visitedTeacher->name,
            'period' => $this->period->name,
            'subject' => $this->subject->name,
            'class' => $this->class->className->name,
            'classNumber' => $this->class->class_number,
            'date' => $this->date,
            'date_type' =>(isset($this->date_type)) ? trans('api.'.$this->date_type) : '',
        ];
    }
}
