<?php

namespace App\Http\Resources\ManagerDashboard\Supervision;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class SupervisionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'title'=>$this->title,
            'semester_id'=>$this->semester_id,
            'semester'=>$this->semester->name,
            'created_at' => $this->supervisors?__('api.not_created_yet'): $this->created_at->format('Y/m/d'),
            'data' => SupervisorResource::collection($this->supervisors)
        ];
    }
}
