<?php

namespace App\Http\Resources\ManagerDashboard\Messages;

use App\Helpers\Helper;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class MessageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $date = Carbon::parse($this->updated_at)->format('d/m/Y');
        return [
            'id' => $this->id,
            'message' => $this->message,
            'type' =>  __('api.'. $this->type),
            'date' => $this->updated_at->format('d/m/Y'),
            'date_options' => Helper::getDateOptions($date, 'coptic'),
            'users' => $this->receptors->map(function ($receptor) {
                return [
                    'user_id' => $receptor->user_id,
                    'name' => $receptor->users?->name,
                ];
            }),
        ];
    }

}
