<?php

namespace App\Http\Resources\ManagerDashboard\LetterAndAlart;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AlertResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'teacher' => $this->employee ? [
            'name' => $this->employee?->name,
            'ssn' => $this->employee?->ssn,
            'specialization'=> $this->employee->Specialization?->title
        ] : null,
            'school_id' => $this->school_id,
            'type' => $this->type,
            'date' => $this->date,
            'notes' => AlertNotesResource::collection($this->notes), // Ensure 'notes' relationship is loaded
        ];
    }
}
