<?php

namespace App\Http\Resources\Event;

use App\Helpers\Helper;
use App\Http\Resources\BaseResource;
use App\Models\Event;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class EventResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'date_type'=>__('api.'.$this->date_type),
            'date' => Carbon::createFromFormat('d/m/Y', $this->date)->format('d/m/Y'),
            'date_options'=> Helper::getDateOptions($this->date, $this->type),
            'time_from' => Carbon::parse($this->time_from)->format('g:i A'),
            'time_to' => Carbon::parse($this->time_to)->format('g:i A'),
            'details'=>$this->details,
        ];
    }
}
