<?php

namespace App\Http\Resources\AdminDashboard\Logs;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class LogResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $data= [
            'id'=>$this->id,
            'user_name'  => optional($this->causer)->name,
            'role_name' => optional($this->causer)->roles->pluck('name'),
            'description'=>__('api.'.$this->event).' '. __('api.' . $this->description).' '.__('api.by') . ' ' . optional($this->causer)->name,
            'created_at' => Carbon::parse($this->created_at)->translatedFormat('l، j F، Y الساعة g:i A'),
        ];
        if(in_array($this->event, ['update', 'store'])){
            $data['event_link']  = url('/api').'/'.env('api_version','v1.0').$this->properties['event_link'];
        }
        return $data;

    }
}
