<?php

namespace App\Http\Resources\AdminDashboard\ExternalSystem;

use App\Http\Resources\BaseResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ExternalSystemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=> $this->id,
            'name'=> $this->name,
            'url'=> $this->url,
            'logo'=> $this->logo ? url('public/uploads/ExternalSystem/'.$this->logo) : trans('api.noImage'),
           // 'status'=>($this->status == 1)?trans('api.active'):trans('api.inactive'),
        ];
    }
}
