<?php

namespace App\Http\Resources\AdminDashboard\Coupons;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CouponResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {


        return [
            'id' => $this->id,
            'code' => $this->code,
            'discount_type' => $this->discount_type,
            'discount_value' => $this->discount_value,
            'coupon_status' => $this->coupon_status,
            'expiration_date' => $this->expiration_date,
            'expiration_date_type' => $this->expiration_date_type,
            'minimum_purchase' => $this->minimum_purchase,
            'maximum_purchase_limit' => $this->maximum_purchase_limit,
            'usage_status_for_users' => $this->usage_status_for_users,
            'usage_limit_per_coupon' => $this->usage_limit_per_coupon,
            'usage_status_for_user' => $this->usage_status_for_user,
            'usage_limit_per_user' => $this->usage_limit_per_user,
            'products' => $this->products->map(function ($product) {
                        
    
                // Calculate the discount amount based on the discount type
                    $discountAmount = $this->discount_type === 'fixed' 
                    ? intval($this->discount_value) 
                    : (intval($product->price * $this->discount_value / 100));
        
                    // Calculate total before and after discount
                $totalBeforeDiscount = intval($product->price);
                  
                $totalAfterDiscount = intval($totalBeforeDiscount - $discountAmount);

                return [
                    'id' => $product->id,
                    'name' => $product->name,
                    'discountAmount' => $discountAmount,
                    'Total before discount' => $totalBeforeDiscount,
                    'Total after discount' => $totalAfterDiscount,
                ];
            })
        ];
    }
}