<?php

namespace App\Http\Resources\AdminDashboard\Category;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return 
        [
            'id' => $this->id,
            'name' => $this->name,
            'parent_id' => $this->parent_id,
            'boardType' => $this->board_type,
            'pageUrl' => $this->page_url,
            'status'=>($this->status == 1)?trans('api.active'):trans('api.inactive'),
            // 'subCategories' => $this->when($this->relationLoaded('subCategories') && $this->subCategories->isNotEmpty(), function () {
            //     return CategoryResource::collection($this->subCategories);
            // }),
            'subCategories' => $this->when(
                    $this->relationLoaded('subCategories'),
                    function () {
                        return $this->subCategories->isNotEmpty()
                            ? CategoryResource::collection($this->subCategories)
                            : [];
                    },
                    []
                ),
        ];
    }
}
