<?php

namespace App\Http\Requests\Violation;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class ViolationTitleStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
 public function rules(Request $request)
    {
        return[
            'name_id' => 'required|string|exists:violation_names,id',
            'violation_type_name'=>'required|array',
            'violation_grade_id' => 'required|string|exists:violation_grades,id',
            'punishment_ids' => 'required|array',
            'punishment_ids.*' => 'exists:namazeg,id', 
        
        ];
        
    }
    

}
