<?php

namespace App\Http\Requests\School;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class SchoolSemesterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
   
        return [
            'name' => 'required|string|max:150',
            'start_date' => 'required|after_or_equal:today',
            'end_date' => 'required|after_or_equal:start_date',
            'start_date_type' => 'required|in:hijri,coptic',
            'end_date_type' => 'required|in:hijri,coptic',
        ];
        
    }
    protected function prepareForValidation()
    {
        $start_date = $this->start_date;
        if (isset($this->start_date_type) && isset($this->start_date)) {
            if ($this->start_date_type == "hijri") {
                $start_date = Helper::getCoptic($this->start_date);
            }
        }

        $end_date = $this->end_date;
        if (isset($this->end_date_type) && isset($this->end_date)) {
            if ($this->end_date_type == "hijri") {
                $end_date = Helper::getCoptic($this->end_date);
            }
        }
        
        $this->merge([
            'start_date' => \Carbon\Carbon::createFromFormat('d/m/Y', $start_date)->format('Y-m-d'),
            'end_date' => \Carbon\Carbon::createFromFormat('d/m/Y', $end_date)->format('Y-m-d'),
        ]);
    }

}

