<?php

namespace App\Http\Requests\School;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class SchoolRegistrRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $step = $request->step;

        switch($step){
            case $step == 1:
                return[
                    'type' => 'required|in:shared,not_shared',
                ];
            break;

            case $step == 2:
                /** school id */
                $id = $this->school_id;
                
                return[
                    'gender' => 'required|in:male,female',
                    'shift' => 'required|in:morning,evening,night',
                    'name'=>'required|string',
                    'ministry_number'=>'required|unique:schools,ministry_number,'.$id,
                    'education_type'=>'required|in:governmental,family',
                    'school_grade_id'=>'exists:school_grades,id',
                    'education_department_id'=>'exists:educational_departments,id',
                    'educational_office_id'=>'exists:educational_offices,id',
                    'founding_date' => 'required',
                    'founding_date_type' => 'required|string|in:coptic,hijri',
                    'address'=>'required|string',
                    'area_id'=>'exists:areas,id',
                    'city_id'=>'exists:cities,id',
                ];
            break;

            case $step == 3:

                return[
                    'building_type'=>'required|in:governmental,rental',
                    'building_status'=>'required|in:dilapidated,well_equipped',
                    'n_class'=>'required|integer',
                    'n_bathrooms'=>'required|integer',
                    'n_floors'=>'required|integer',
                    'n_team_rooms'=>'required|integer',
                    'n_management_rooms'=>'required|integer',
                    'n_computer_laps'=>'required|integer',
                    'n_science_laps' =>'required|integer',
                    'n_ware_houses'=>'required|integer',
                    'n_learning_resources'=>'required|integer',
                    'n_activity_rooms'=>'required|integer',
                    'n_meeting_rooms'=>'required|integer',
                    'n_sport_houses'=>'required|integer',
                    'n_theaters'=>'required|integer',
                    'n_playgrouonds'=>'required|integer',
                    'n_outdoors_court'=>'required|integer',
                ];
            break;

            case $step == 4:
                return[
                    'file' => 'required|mimes:xlsx'
                ];
            break;

            case $step == 5:
                return[
                    'file' => 'required|mimes:xlsx'
                ];
            break;

            case $step == 6:
                return[
                    'name'=>'required|string',
                    'ssn'=>'required|unique:school_employees',
                    'email' => 'required|string|email|max:255|unique:school_employees',
                    'phone' => 'required|string|unique:school_employees',
                    'current_work_id'=>'exists:current_works,id',
                    'specialization_id'=>'exists:specializations,id',
                    'school_id'=>'exists:schools,id',
                ];
            break;

            case $step == 7:
                return[

                ];
            break;

        }        
    }

    // Optionally, define custom error messages
    public function messages()
    {
        return [

        ];
    }

}
