<?php

namespace App\Http\Requests\ManagerDashboard\TeacherSchedule;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class TeacherScheduleUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
 public function rules(Request $request)
    {
        return [
            'data' => 'required|array',
            'data.*.day_id' => 'required|integer|exists:days,id',
            'data.*.data' => 'required|array',
            'data.*.data.*.school_employee_id' => 'required|integer|exists:school_employees,id',
            'data.*.data.*.subject_id' => 'required|integer|exists:subjects,id',
            'data.*.data.*.period_id' => 'required|integer|exists:periods,id',


        ];
        
    }

}
