<?php

namespace App\Http\Requests\ManagerDashboard\Tables\ClassRoomVisits;

use Illuminate\Foundation\Http\FormRequest;

class UpdateClassVisitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'school_id' => ['exists:schools,id'],
            'data' => ['array'],
            'data.*.semester_id' => [ 'integer', 'exists:semesters,id'],
            'data.*.visites' => [ 'array'],
            'data.*.visites.*.visiting_teacher_id' => [ 'integer', 'exists:school_employees,id'],
            'data.*.visites.*.visited_teacher_id' => [ 'integer', 'exists:school_employees,id'],
            'data.*.visites.*.period_id' => [ 'integer', 'exists:periods,id'],
            'data.*.visites.*.subject_id' => [ 'integer', 'exists:subjects,id'],
            'data.*.visites.*.school_class_id' => ['integer','exists:school_classes,id'],
            'data.*.visites.*.date_type' => [ 'in:hijri,coptic'],
            'data.*.visites.*.date' => ['nullable']
        ];
    }
}
