<?php

namespace App\Http\Requests\ManagerDashboard\Tables\ClassRoomVisits;

use Illuminate\Foundation\Http\FormRequest;

class StoreClassRoomVisitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'school_id' => ['required','exists:schools,id'],
            'data' => ['required', 'array'],
            'data.*.semester_id' => ['required', 'integer', 'exists:semesters,id'],
            'data.*.visites' => ['required', 'array'],
            'data.*.visites.*.visiting_teacher_id' => ['required', 'integer', 'exists:school_employees,id'],
            'data.*.visites.*.visited_teacher_id' => ['required', 'integer', 'exists:school_employees,id'],
            'data.*.visites.*.period_id' => ['required', 'integer', 'exists:periods,id'],
            'data.*.visites.*.subject_id' => ['required', 'integer', 'exists:subjects,id'],
            'data.*.visites.*.school_class_id' => ['required','integer','exists:school_classes,id'],
            'data.*.visites.*.date_type' => ['required', 'in:hijri,coptic'],
            'data.*.visites.*.date' => ['required'],
        ];
    }


    public function messages()
    {
        return [
           'data.required' => 'حقل البيانات مطلوب.',
            'data.array' => 'حقل البيانات يجب أن يكون مصفوفة.',
            'data.*.semester_id.required' => 'حقل المعرف للفصل الدراسي مطلوب.',
            'data.*.semester_id.integer' => 'حقل المعرف للفصل الدراسي يجب أن يكون عدداً صحيحاً.',
            'data.*.semester_id.exists' => 'الفصل الدراسي المحدد غير موجود.',
            'data.*.visites.required' => 'حقل الزيارات مطلوب.',
            'data.*.visites.array' => 'حقل الزيارات يجب أن يكون مصفوفة.',
            'data.*.visites.*.visiting_teacher_id.required' => 'حقل المعلم الزائر مطلوب.',
            'data.*.visites.*.visiting_teacher_id.integer' => 'حقل المعلم الزائر يجب أن يكون عدداً صحيحاً.',
            'data.*.visites.*.visiting_teacher_id.exists' => 'المعلم الزائر المحدد غير موجود.',
            'data.*.visites.*.visited_teacher_id.required' => 'حقل المعلم الزائر إليه مطلوب.',
            'data.*.visites.*.visited_teacher_id.integer' => 'حقل المعلم الزائر إليه يجب أن يكون عدداً صحيحاً.',
            'data.*.visites.*.visited_teacher_id.exists' => 'المعلم الزائر إليه المحدد غير موجود.',
            'data.*.visites.*.period_id.required' => 'حقل الفترة مطلوب.',
            'data.*.visites.*.period_id.integer' => 'حقل الفترة يجب أن يكون عدداً صحيحاً.',
            'data.*.visites.*.period_id.exists' => 'الفترة المحددة غير موجودة.',
            'data.*.visites.*.subject_id.required' => 'حقل المادة مطلوب.',
            'data.*.visites.*.subject_id.integer' => 'حقل المادة يجب أن يكون عدداً صحيحاً.',
            'data.*.visites.*.subject_id.exists' => 'المادة المحددة غير موجودة.',
            'data.*.visites.*.class_id.required' => 'حقل الصف مطلوب.',
            'data.*.visites.*.class_id.integer' => 'حقل الصف يجب أن يكون عدداً صحيحاً.',
            'data.*.visites.*.class_id.exists' => 'الصف المحدد غير موجود.',
            'data.*.visites.*.class_number.required' => 'حقل رقم الفصل مطلوب.',
            'data.*.visites.*.class_number.integer' => 'حقل رقم الفصل يجب أن يكون عدداً صحيحاً.',
            'data.*.visites.*.date_type.required' => 'حقل نوع التاريخ مطلوب.',
            'data.*.visites.*.date_type.in' => 'نوع التاريخ يجب أن يكون "هجري" أو "قبطي".',
            'data.*.visites.*.date.required' => 'حقل التاريخ مطلوب.',
            'data.*.visites.*.date.date_format' => 'التاريخ يجب أن يكون بتنسيق "يوم/شهر/سنة".',
        ];
    }
}
