<?php

namespace App\Http\Requests\ManagerDashboard\Supervision;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class SupervisionUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
 public function rules(Request $request)
    {
        return [
            'title' => 'required|string',
            'data' => 'required|array',
            'data.*.day_id' => 'required|integer|exists:days,id',
            'data.*.data' => 'required|array',
            'data.*.data.*.floor_id' => 'required|integer|exists:floors,id',
            'data.*.data.*.school_employee_id' => 'required|array',
            'data.*.data.*.school_employee_id.*' => 'required|integer|exists:school_employees,id',
        ];
        
    }

}
