<?php

namespace App\Http\Requests\ManagerDashboard\LettersAndAlarts;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAlertRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'school_id' => ['integer','exists:schools,id'],
            'type' => ['required','in:verbal,written'],
            'date_type' => ['required','in:hijri,coptic'],
            'date' => ['required'],
            'alert_direct_to' => ['required','string','max:255'],
            'notes' => ['sometimes','array'],
        ];
    }

    public function messages(): array
    {
        return [
            'type.required' => 'حقل النوع مطلوب.',
            'type.in' => 'القيمة المدخلة في حقل النوع غير صالحة.',
            'date_type.required' => 'حقل نوع التاريخ مطلوب.',
            'date_type.in' => 'القيمة المدخلة في حقل نوع التاريخ غير صالحة.',
            'date.required' => 'حقل التاريخ مطلوب.',
            'date.date' => 'حقل التاريخ يجب أن يكون تاريخًا صحيحًا.',
            'name.required' => 'حقل الاسم مطلوب.',
            'name.string' => 'حقل الاسم يجب أن يكون نصًا.',
            'name.max' => 'حقل الاسم يجب ألا يتجاوز 255 حرفًا.',
            'notes.required' => 'حقل الملاحظات مطلوب.',
            'notes.array' => 'حقل الملاحظات يجب أن يكون مصفوفة.',
        ];
    }
}
