<?php

namespace App\Http\Requests\ManagerDashboard\ClassRoomVisit;

use Illuminate\Foundation\Http\FormRequest;

class UpdateClassRoomVisitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'school_id' => ['integer','exists:schools,id'],
            'semester_id' => ['integer','exists:semesters,id'],
            'school_teacher_id' => ['integer','exists:school_employees,id'],
            'school_class_id' => ['integer','exists:school_classes,id'],
            'date' => ['nullable' ],
            'date_type' => ['in:coptic,hijri'],
            'visit_officer_id' => ['exists:school_employees,id'],
            'visit_period_id' => ['exists:periods,id'],
            'visit_status' => ['in:complete,incomplete'],
         ];
    }
}