<?php

namespace App\Http\Requests\ManagerDashboard\Circulars;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class StudentGeneralCircularRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return[
            'school_id' => 'required|integer|exists:schools,id',
            'class_id' => 'nullable|integer|exists:school_classes,id',
            'semesters_id' => 'nullable|integer|exists:semesters,id',
            'directed_to' => 'required|in:class_name_and_number,class_name,all',
            'title' => 'required|string|max:255',
        ];
    }

}
