<?php

namespace App\Http\Requests\ManagerDashboard\Assignments;

use Illuminate\Foundation\Http\FormRequest;

class GeneralAssignmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'school_id' => 'required|exists:schools,id',
            'date' => 'required|date_format:d/m/Y',
            'date_type' => 'required|string|in:coptic,hijri',
            'duration_id' => 'required|integer|exists:duration_assignments,id', 
            'details' => 'nullable|string',
            'employees' => 'required|array',
            'employees.*' => 'required|integer|exists:school_employees,id',
        ];
    }
}
