<?php

namespace App\Http\Requests\ManagerDashboard\Assignments;

use Illuminate\Foundation\Http\FormRequest;

class AssignmentTeamRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'assignment.date' => 'required|date_format:d/m/Y',
            'assignment.date_type' => 'required|string|in:coptic,hijri',
            
            'team_members' => 'required|array|min:1',
            'team_members.*.employee_id' => 'required|integer|exists:school_employees,id',
            'team_members.*.assiment_work' => 'required|string',

            'team_semesters_meetings' => 'required|array|min:1',
            'team_semesters_meetings.*.semester_id' => 'required|integer|exists:semesters,id',
            'team_semesters_meetings.*.meetings' => 'required|array|min:1',
            'team_semesters_meetings.*.meetings.*.name' => 'required|string',
            'team_semesters_meetings.*.meetings.*.date' => 'required|date_format:d/m/Y',
            'team_semesters_meetings.*.meetings.*.date_type' => 'required|string|in:coptic,hijri',
            'team_semesters_meetings.*.meetings.*.place' => 'nullable|string',
        ];
    }
}
