<?php
namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Http\Resources\User\RoleResource;

class RoleController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        //$this->middleware(['auth:api','permission:roles']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request){
        $roles =RoleResource::collection(Role::paginate($request->per_pag));
        return response()->json(['roles'=>$roles,'message'=>trans('api.list of all available records')]);
    }

    /* this method will stord data to DB Model*/
    public function store(Request $request)
    {
        $existingRole = Role::where('name', $request->name)->first();
        if ($existingRole) {
            return response()->json([
                'message' => trans('api.Role already exists'),
            ], 400);
        }

        $role = Role::create(['name' => $request->name, 'guard_name' => 'web']);

        $permissions = explode(",", $request->permissions);
        $availablePermissions = Permission::whereIn('name', $permissions)->pluck('name')->toArray();

        if (count($availablePermissions) !== count($permissions)) {
            $role->delete();
            return response()->json([
                'message' => trans('api.Some permissions are invalid'),
                'invalid_permissions' => array_diff($permissions, $availablePermissions),
            ], 400);
        }

        $role->syncPermissions($availablePermissions);

        return response()->json(['message' => trans('api.record stored successfully')]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(Request $request){
        $role = Role::findOrFail($request->role_id);
        /* update role name*/
        $role->name= $request->name;
        $role->save();
        /* remove old permissions from role add new one */
        $rolePermissions= $role->permissions()->get();
        foreach($rolePermissions as $rolePermission){
            $role->revokePermissionTo($rolePermission);
        }
        $role->syncPermissions($request->permissions);
        return response()->json(['message'=>trans('api.role and role permissions updated successflly')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete(Request $request){
        $role =Role::findOrFail($request->role_id);
        $role->delete();
        return response()->json(['message'=>trans('api.record deleted successflly')]);
    }
}