<?php
namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Models\PermissionGroup;
use Spatie\Permission\Models\Permission;
use App\Http\Resources\User\PermissionGroupResource;

class PermissionController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        //$this->middleware(['auth:api','permission:permissions']);
    }

    /*
        -this method will return all Super Admin permissions
    */
    public function SuperAdminPermissions(){
        $permissions =PermissionGroupResource::collection(PermissionGroup::where('type','super_admin')->get());
        return response()->json(['permissions_groups'=>$permissions,'message'=>trans('api.list of all available records')]);
    }

    /*
        -this method will return all School Manager permissions
    */
    public function SchoolManagerPermissions(){
        $permissions =PermissionGroupResource::collection(PermissionGroup::where('type','school_manager')->get());
        return response()->json(['permissions_groups'=>$permissions,'message'=>trans('api.list of all available records')]);
    }

    /* this method will stord data to DB Model*/
    public function store(Request $request){
        /* add permission group*/
        $permissionGroup = new PermissionGroup();
        $permissionGroup->name=$request->permission_group_name;
        $permissionGroup->type=$request->type;
        $permissionGroup->save();

        /* add permissions to permission group*/
        if($request->permission_name){
            $permissionNames= $request->permission_name;
            foreach($permissionNames as $permissionName){
                $permission = Permission::create(['name' => $permissionName,'permission_group_id'=>$permissionGroup->id]);
            }
        }
        return response()->json(['message'=>trans('api.record stored successflly')]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function updatePermissionGroup(Request $request){
        $permissionGroup =PermissionGroup::findOrFail($request->permission_group_id);
        /* update permission group name*/
        $permissionGroup->name = $request->permission_group_name;
        $permissionGroup->save();
        return response()->json(['message'=>trans('api.permission Group Name updated successflly')]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function updatePermission(Request $request){
        $permission =Permission::findOrFail($request->permission_id);
        /* update permission name*/
        $permission->name = $request->permission_name;
        $permission->save();
        return response()->json(['message'=>trans('api.permission Name updated successflly')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function deletePermissionGroup(Request $request){
        $permissionGroup =PermissionGroup::findOrFail($request->permission_group_id);
        $permissionGroup->delete();
        return response()->json(['message'=>trans('api.record deleted successflly')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function deletePermission(Request $request){
        $permission =Permission::find($request->permission_id);
        $permission->delete();
        return response()->json(['message'=>trans('api.record deleted successflly')]);
    }
    
}