<?php

namespace App\Http\Controllers\Api\School;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\School\SchoolStudentResource;
use JWTAuth;

use Illuminate\Http\Request;
use App\Http\Requests\School\StudentRequest;

use App\Models\AdminDashboard\School\Student;


class StudentController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api',,'permission:students']);
    }


    /** function store school student informations */
    public function store(StudentRequest $request){
        $data=$request->all();
        $data['current_school_year'] = Helper::getSchoolYear();
        $student= Student::create($data);
        $student = new SchoolStudentResource($student); 
        return response()->json(['student'=>$student,'message'=>trans('api.record stored successfully')]);
    }

    /** function show school student informations */
    public function show(Request $request){
        $student= Student::findOrFail($request->student_id);
        $student = new SchoolStudentResource($student);        
        return response()->json(['student'=>$student,'message'=>trans('api.record details')]);
    }

    /** function update school student informations */
    public function update(StudentRequest $request,$id){
        $student= Student::findOrFail($id);
        $student->update($request->all());     
        $student = new SchoolStudentResource($student);   
        return response()->json(['student'=>$student,'message'=>trans('api.record updated successfully')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function destroy(Request $request){
        Student::findOrFail($request->student_id)->forceDelete();
        return response()->json(['message'=>trans('api.record deleted successflly')]);
    }

}
