<?php

namespace App\Http\Controllers\Api\School;

use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Http\Requests\School\SchoolRegistrRequest;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolReference;
use App\Models\AdminDashboard\School\SchoolFacilitie;
use App\Helpers\Helper;
use App\Http\Resources\School\SchoolEmployeeResource;
use App\Http\Resources\School\SchoolFacilitieResource;
use App\Http\Resources\School\SchoolReferenceResource;
use App\Http\Resources\School\SchoolResource;
use App\Models\AdminDashboard\School\Student;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;

use App\Imports\StudentsImport;
use App\Imports\TeachersImport;
use App\Jobs\SendEmailJob;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;

class SchoolRegistrationController extends Controller
{
   

    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api']);
    }

    public function register(SchoolRegistrRequest $request ,$step){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        
        switch($step){

            /** school type must be shared or not shared value */
            case $step == 1:

                $userSchools = School::where('user_id',$user->id)->get();
                if(count($userSchools) > 0 && count($userSchools) == 2){
                    return response()->json(['message' => trans('api.you can not add new school')],401);
                }

                if($request->type == 'shared'){
                    /**school 1 */
                    $school1= School::create(['user_id'=>$user->id,'current_school_year'=>Helper::getSchoolYear(),'reg_step1'=>'completed']);
                    $school1Facilities= SchoolFacilitie::create(['school_id'=>$school1->id]);
                    $school1Reference= SchoolReference::create(['school_id'=>$school1->id]);

                    /**school 2 */
                    $school2= School::create(['user_id'=>$user->id,'current_school_year'=>Helper::getSchoolYear(),'reg_step1'=>'completed']);
                    $school2Facilities= SchoolFacilitie::create(['school_id'=>$school2->id]);
                    $school2Reference= SchoolReference::create(['school_id'=>$school2->id]);  
                    return response()->json(['schoolIds'=>[$school1->id,$school2->id],'message' => trans('api.school initial data stored successfully')]);
                     
                }else{
                    $school= School::create(['user_id'=>$user->id,'current_school_year'=>Helper::getSchoolYear(),'reg_step1'=>'completed']);
                    $schoolFacilities= SchoolFacilitie::create(['school_id'=>$school->id]);
                    $schoolReference= SchoolReference::create(['school_id'=>$school->id]);
                    return response()->json(['schoolIds'=>[$school->id],'message' => trans('api.school initial data stored successfully')]);
                }
            break;

            /** school main informations */
            case $step == 2:
                $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
                $school->update($request->except('school_id'));
                $school= new SchoolResource($school);
                return response()->json(['school'=>$school,'message' => trans('api.school data updated successfully')]);
            break;

            /** school facilitie main informations */
            case $step == 3:
                $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
                $schoolFacilitie = SchoolFacilitie::where('school_id',$school->id)->firstOrFail();
                $schoolFacilitie->update($request->all());
                $school->update(['reg_step3'=>'completed']);
                $schoolFacilitie= new SchoolFacilitieResource($schoolFacilitie);
                return response()->json(['schoolFacilitie'=>$schoolFacilitie,'message' => trans('api.school facilities updated successfully')]);
            break;

            /** importing students data */
            case $step == 4:
                $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();


                /** delete school old records before upload new file */
                SchoolClass::where('school_id',$school->id)->delete();
                Student::where('school_id',$school->id)->forceDelete();
                
                $file= $request->file('file');
                $skipRows =[0,1,2,6,5,9,10,13,14,15,16,17,18]; // Define the rows to skip
                Excel::import(new StudentsImport($file,$skipRows,$request->school_id), $file);
                $school->update(['reg_step4'=>'completed']);
                return response()->json(['message' => trans('api.students data imported successfully')]);
            break;

            /** importing teachers data */
            case $step == 5:
                $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

                /** delete school old records before upload new file */
                // Start a database transaction
                DB::beginTransaction();
                try {
                    // Fetch related users
                    $employees = SchoolEmployee::where('type', 'teacher')->where('school_id', $school->id)->get();
                    // Get user IDs to delete
                    $userIds = $employees->pluck('user_id');

                    //dd($userIds,$employees);
                    // Delete related users
                    User::whereIn('id', $userIds)->forceDelete();
                    // Delete school employees
                    SchoolEmployee::where('type', 'teacher')->where('school_id', $school->id)->forceDelete();
                    // Commit the transaction
                    DB::commit();
                } catch (\Exception $e) {
                    // Rollback the transaction if something goes wrong
                    DB::rollBack();
                    // Log the exception or handle the error as needed
                    Log::error('Error deleting records: ' . $e->getMessage());
                }

                /*upload file after deleting old records if found */
                $file= $request->file('file');
                $skipRows = [0,1,2,3,4,5,6,7,8,9,10,11,12,13]; // Define the rows to skip
                Excel::import(new TeachersImport($file,$skipRows,$request->school_id), $file);
                $school->update(['reg_step5'=>'completed']);

                // Get all registered users
                $school_employees = SchoolEmployee::where('type','teacher')->where('school_id',$school->id)->get();
                
                /** send email with email caradentials to all employees */
                foreach ($school_employees as $school_employee) {
                    /** create users accounts */
                    $temp_password =  'teacher'.mt_rand(100000, 999999);
                    $this->createUserAccounts($school_employee->id,$school_employee->name,$school_employee->email,$school_employee->phone,$temp_password);
                    SendEmailJob::dispatch($school_employee); // Dispatch the job for each school employee
                }
                
                return response()->json(['message' => trans('api.teachers data imported successfully')]);
            break;

            case $step == 6:
                $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
                $data = $request->all();
                $data['type']='adminstrative';
                $adminstrative=SchoolEmployee::create($data);

                /** create users accounts */
                $temp_password =  'adminstrative'.mt_rand(100000, 999999);
                $this->createUserAccounts($adminstrative->id,$adminstrative->name,$adminstrative->email,$adminstrative->phone,$temp_password);

                $adminstrative = new SchoolEmployeeResource($adminstrative); 
                $school->update(['reg_step6'=>'completed','registration_complete'=>'yes']);

                return response()->json(['adminstrative'=>$adminstrative,'message' => trans('api.adminstrative record stored successfully')]);
            break;

            /** school references main informations */
            case $step == 7:
                $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
                $schoolReference = SchoolReference::where('school_id',$school->id)->firstOrFail();
                $schoolReference->update($request->all());
                $school->update(['reg_step7'=>'completed','registration_complete'=>'yes']);
                $schoolReference= new SchoolReferenceResource($schoolReference);

                /**save teacher schedules*/
                Helper::saveTeacherSchedules($school->id);
                
                /**save  super vision schedules*/
                Helper::saveSupervisionSchedules($school->id);    
                
                return response()->json(['schoolReference'=>$schoolReference,'message' => trans('api.school reference updated successfully')]);
            break;
        }
    }

    /** method check the school registration steps
     *  to move to incompleted stepd */
    public function checkSchoolRegSteps(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();        
        $regSteps=[
            'step1'=> $school->reg_step1,
            'step2'=> $school->reg_step2,
            'step3'=> $school->reg_step3,
            'step4'=> $school->reg_step4,
            'step5'=> $school->reg_step5,
            'step6'=> $school->reg_step6,
            'step7'=> $school->reg_step7,
        ];
        return response()->json(['regSteps'=>$regSteps,'message' => trans('api.school registration steps status')]);
    }

    public function createUserAccounts($empId,$name,$email,$phone,$temp_password){
        $user = new User();
        $user->name = $name ;
        $user->email = $email ;
        $user->phone = $phone ;
        $user->password = Hash::make($temp_password) ;
        // $user->remember_token = $request->remember_token ;
        $user->status = 'active' ;
        $user->user_type = 'teacher' ;
        $user->verification_code = mt_rand(100000, 999999);
        $user->save();

        /** add user Id to school employee */
        $schoolEmployee = SchoolEmployee::find($empId);
        $schoolEmployee->user_id = $user->id;
        $schoolEmployee->save();
    }
}
