<?php

namespace App\Http\Controllers\Api\School;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\AdminDashboard\School\SchoolGradeRequest;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;
use Illuminate\Http\Request;
use App\Http\Requests\UpdateStatusRequest;
use App\Http\Resources\AdminDashboard\School\SchoolGradeResource;
use App\Http\Resources\School\SubjectResource;
use App\Models\AdminDashboard\School\SchoolGrade;
use App\Models\AdminDashboard\School\Subject;

class SchoolGradeController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:school-grades']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request)
    {

        // Start with the base query
        $data = SchoolGrade::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\AdminDashboard\School\SchoolGrade', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $paginatedData = $data->paginate($perPage);

        // Transform the data using SchoolGradeResource
        $schoolGrades = SchoolGradeResource::collection($paginatedData);

        return response()->json([
            'schoolGrades' => $schoolGrades,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById(SchoolGrade $grade)
    {
        $grade =  new SchoolGradeResource($grade);

        return  response()->json(['grade' => $grade]);
    }

    /* this method will stord data to DB Model*/
    public function store(SchoolGradeRequest $request)
    {
        $data =  $request->validated();

        SchoolGrade::create($data);

        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(SchoolGrade $grade)
    {
        $grade = new SchoolGradeResource($grade);

        return  response()->json(['grade' => $grade]);
    }


    /* this method will update specific Model recored 
        by using ID
    */
    public function update(SchoolGradeRequest $request, SchoolGrade $grade)
    {

        $data = $request->validated();
        $grade->update($data);

        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(UpdateStatusRequest $request, SchoolGrade $grade)
    {

        $grade->status = $request->status;
        $grade->save();
        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive(SchoolGrade $grade)
    {

        $grade->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function destroy(SchoolGrade $grade)
    {

        $grade->forceDelete();

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore(SchoolGrade $grade)
    {
        $grade->restore();

        return response()->json(['message' => trans('api.record restored successflly')]);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function getSubjects(Request $request){

        $subjects =SubjectResource::collection(Subject::where('school_grade_id',$request->school_grade_id)->
                                                        where('class_name_id',$request->class_name_id)->
                                                        where('semester_id',$request->semester_id)->get());
        return response()->json(['subjects'=>$subjects,'message' => trans('api.list of all available subjects')]);
    }
}
