<?php

namespace App\Http\Controllers\Api\School;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\School\GuideRegulationRequest;
use App\Models\GuideRegulation;
use App\Http\Resources\School\GuideRegulationResource;

class GuideRegulationController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        //$this->middleware(['auth:api','permission:school-semesters']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request){
        // Start with the base query
        $data = GuideRegulation::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\GuideRegulation', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = GuideRegulationResource::collection($data->paginate($perPage));

        return response()->json([
            'guideRegulations' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById(GuideRegulation $guideRegulation){
        $guideRegulation = new GuideRegulationResource($guideRegulation);
        return response()->json(['guideAndRegulation'=>$guideRegulation,'message'=>trans('api.guide and Regulation details')],200);
    }

    /* this method will stord data to DB Model*/
    public function store(GuideRegulationRequest $request){
        $guideRegulation = new GuideRegulation();
        $guideRegulation->name = $request->name;
        $guideRegulation->status = $request->status;
        $guideRegulation->save();

        return response()->json(['message'=>trans('api.record stored successflly')],200);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(GuideRegulationRequest $request,GuideRegulation $guideRegulation){
        $guideRegulation->name = $request->name;
        $guideRegulation->status = $request->status;
        $guideRegulation->save();
        return response()->json(['message'=>trans('api.record updated successflly')],200);
    }

    /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(Request $request,GuideRegulation $guideRegulation){
        $guideRegulation->status = $request->status;
        $guideRegulation->save();
        return response()->json(['message'=>trans('api.status changed successflly')],200);
    }

        /* this method will archive specific Model recored 
        by using ID
    */
    public function archive(GuideRegulation $guideRegulation){
        $guideRegulation->delete();
        return response()->json(['message'=>trans('api.record archived successflly')],200);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function destroy(GuideRegulation $guideRegulation){
        $guideRegulation->forceDelete();
        return response()->json(['message'=>trans('api.record deleted successflly')],200);
    }

        /* this method will restore specific Model recored 
        by using ID
    */
    public function restore(GuideRegulation $guideRegulation){
        $guideRegulation->restore();
        return response()->json(['message'=>trans('api.record restored successflly')],200);
    }
    
}