<?php

namespace App\Http\Controllers\Api\ManagerDashboard\TrashedRecord;

use App\Http\Controllers\Controller;
use App\Http\Resources\TrashedRecordResource;
use App\Models\ManagerDashboard\Assignments\Assignment;
use App\Models\ManagerDashboard\Circulars\InternalCircular;
use App\Models\ManagerDashboard\Circulars\InternalCircularTeacher;
use App\Models\ManagerDashboard\Circulars\StudentGeneralCircular;
use App\Models\ManagerDashboard\Circulars\StudentGeneralCircularStudent;
use App\Models\ManagerDashboard\Circulars\TeacherGeneralCircular;
use App\Models\ManagerDashboard\Circulars\TeacherGeneralCircularTeacher;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRate;
use App\Models\ManagerDashboard\ClassRoomVisits\VisitMethod;
use App\Models\ManagerDashboard\NotificationMessage;
use App\Models\ManagerDashboard\NotificationReciver;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use App\Models\ManagerDashboard\OfficialSpeeches\AlertNote;
use App\Models\ManagerDashboard\OfficialSpeeches\Letter;
use App\Models\ManagerDashboard\Proceed;
use App\Models\ManagerDashboard\SupervisionSchedul;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftTeacher;
use App\Models\ManagerDashboard\Tables\Teacher;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Meeting;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\MeetingRecommendation;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\MeetingSchedual;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team;
use App\Models\TrashedRecord;
use Illuminate\Support\Facades\DB;

class TrashedRecordController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:trashed-records']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll()
    {
        $models = [
            Assignment::class, //0
            InternalCircular::class, //1
            StudentGeneralCircular::class,//1
            TeacherGeneralCircular::class,//1
            ClassRoomVisitSession::class, //1
            Alert::class,//0
            Letter::class,//0
            ShiftSchedule::class,//1
            ShiftTeacher::class,//0
            Committee::class,//1
            Meeting::class,//1
            Team::class,//1
            NotificationMessage::class,//0
            NotificationReciver::class,//0
            Proceed::class,//1
            SupervisionSchedul::class//1
        ];

        /** empty old trashes then re add again */
        DB::statement('TRUNCATE TABLE trashed_records');


        foreach ($models as $model) {
            $trashedRecords = $model::onlyTrashed()->get();
        
            foreach ($trashedRecords as $record) {
                TrashedRecord::create([
                    'model' => class_basename($model),
                    'record_id' => $record->id,
                    'school_id' => $record->school_id,
                    'deleted_at' => $record->deleted_at,
                ]);
            }
        }

        // Retrieve all trashed records from the database
        $trashedRecords = TrashedRecord::all();
        // Return them as a collection of resources
        $trashedRecords = TrashedRecordResource::collection($trashedRecords);
        return response()->json(['trashedRecords'=>$trashedRecords,'message' => trans('api.list of all available records')], 200);        
    }

}
