<?php

namespace App\Http\Controllers\Api\ManagerDashboard\TeamAndCommitteeMeetings;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\TeamAndCommitteeMeetings\TeamRequest;
use Illuminate\Http\Request;
use App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings\TeamResource;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team;
use App\Traits\LogsActivity;

class TeamController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        //$this->middleware(['auth:api','permission:teams']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request){
        // Start with the base query

        $data = Team::query();
        $school_id = $request->input('school_id');


        // Retrieve all query parameters
        $queryParams = $request->query();
        unset($queryParams['school_id']);

        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        if($request->school_id) {
            $filterData = TeamResource::collection($data->where('school_id',$school_id)->paginate($perPage));
        } else {
            $filterData = TeamResource::collection($data->paginate($perPage));
        }

        return response()->json([
            'teams' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById(Team $team){
        $team = new TeamResource($team);
        return response()->json(['teams'=>$team,'message'=>trans('api.team details')],200);
    }

    /* this method will stord data to DB Model*/
    public function store(TeamRequest $request){
        $lang = $request->header('lang');

        $data = $request->validated();

        $team = new Team();
        $team->name = $data['name'];
        $team->assignment_form_number =  $data['assignment_form_number'];
        $team->school_id =  $data['school_id'];
        $team->status =  $data['status'];
        $team->save();
        // ------------------------------- School ID -----------------------
        $school_id =  $data['school_id'];
        $this->ManagerlogActivity('Team', 'store', $school_id, '/teams/' . $team->id);

        return response()->json(['message'=>trans('api.record stored successflly')],200);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(TeamRequest $request,Team $team){
        $lang = $request->header('lang');
        $data =  $request->validated();
        $team->name =  $data['name'];
        $team->assignment_form_number =  $data['assignment_form_number'];
        $team->school_id =  $data['school_id'];
        $team->status =  $data->status;
        $team->save();
        // ------------------------------- School ID -----------------------
        $school_id =  $data->school_id;
        $this->ManagerlogActivity('Team', 'update', $school_id, '/teams/' . $team->id);

        return response()->json(['message'=>trans('api.record updated successflly')],200);
    }

    /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(Request $request,Team $team){
        $team->status = $request->status;
        $team->save();
        return response()->json(['message'=>trans('api.status changed successflly')],200);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive(Team $team){
        $school_id = $team->school_id;
        $team->delete();
        $this->ManagerlogActivity('Team', 'archive', $school_id);


        return response()->json(['message'=>trans('api.record archived successflly')],200);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function destroy(Team $team){
        $school_id = $team->school_id;
        $team->forceDelete();
        $this->ManagerlogActivity('Team', 'delete', $school_id);
        return response()->json(['message'=>trans('api.record deleted successflly')],200);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore(Team $team){
        $school_id = $team->school_id;
        $team->restore();
        $this->ManagerlogActivity('Team', 'restore', $school_id);
        return response()->json(['message'=>trans('api.record restored successflly')],200);
    }
    
}