<?php

namespace App\Http\Controllers\Api\ManagerDashboard\TeamAndCommitteeMeetings;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;

use App\Http\Requests\ManagerDashboard\TeamAndCommitteeMeetings\CommitteeRequest;
use Illuminate\Http\Request;
use App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings\CommitteeResource;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Traits\LogsActivity;

class CommitteeController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        //$this->middleware(['auth:api','permission:school-semester-vacations']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request){
        // Start with the base query
        $data = Committee::query();
        $school_id = $request->input('school_id');

        // Retrieve all query parameters
        $queryParams = $request->query();
        unset($queryParams['school_id']);

        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        if($request->school_id) {
            $filterData = CommitteeResource::collection($data->where('school_id',$school_id)->paginate($perPage));
        } else {
            $filterData = CommitteeResource::collection($data->paginate($perPage));
        }

        return response()->json([
            'commitees' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById(Committee $committee){
        $committee = new CommitteeResource($committee);
        return response()->json(['committee'=>$committee,'message'=>trans('api.committee details')],200);
    }

    /* this method will stord data to DB Model*/
    public function store(CommitteeRequest $request){
        $lang = $request->header('lang');
        $data = $request->validated();
        $committee = new Committee();
        $committee->name =  $data['name'];
        $committee->assignment_form_number =  $data['assignment_form_number'];
        $committee->school_id =  $data['school_id'];
        $committee->status =  $data['status'];
        $committee->save();
        // ------------------------------- School ID -----------------------
        $school_id = $request->school_id;
        $this->ManagerlogActivity('Committee', 'store', $school_id, '/committees/' . $committee->id . '/details');

        return response()->json(['message'=>trans('api.record stored successflly')],200);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(CommitteeRequest $request,Committee $committee){
        $lang = $request->header('lang');
        $data = $request->validated();
        $committee->name =  $data->name;
        $committee->school_id =  $data->school_id;
        $committee->status =  $data->status;
        $committee->save();
        // ------------------------------- School ID -----------------------
        $school_id = $committee->school_id;
        $this->ManagerlogActivity('Committee', 'update', $school_id, '/committees/' . $committee->id . '/details');


        return response()->json(['message'=>trans('api.record updated successflly')],200);
    }

    /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(Request $request,Committee $committee){
        $committee->status = $request->status;
        $committee->save();

        return response()->json(['message'=>trans('api.status changed successflly')],200);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive(Committee $committee){
        $school_id = $committee->school_id;
        $committee->delete();
        // ------------------------------- School ID -----------------------
        $this->ManagerlogActivity('Committee', 'archive', $school_id);

        return response()->json(['message'=>trans('api.record archived successflly')],200);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function destroy(Committee $committee){
        $school_id = $committee->school_id;
        $committee->forceDelete();
        $this->ManagerlogActivity('Committee', 'delete', $school_id);
        return response()->json(['message'=>trans('api.record deleted successflly')],200);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore(Committee $committee){
        $school_id = $committee->school_id;
        $committee->restore();
        $this->ManagerlogActivity('Committee', 'restore', $school_id);
        return response()->json(['message'=>trans('api.record restored successflly')],200);
    }

    
}