<?php

namespace App\Http\Controllers\Api\ManagerDashboard\TeacherSchedule;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\ManagerDashboard\TeacherSchedule\TeacherScheduleStoreRequest;
use App\Http\Requests\ManagerDashboard\TeacherSchedule\TeacherScheduleUpdateRequest;
use App\Http\Resources\ManagerDashboard\TeacherSchedule\SchoolClassResource;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\ManagerDashboard\TeacherSchedule;
use App\Models\ManagerDashboard\TeacherScheduleData;
use App\Traits\LogsActivity;

class TeacherScheduleController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:teacherSchedules']);
    }

    /*
        -this method will return all Model recoreds
    */
  
    public function getAll(Request $request, $school_id)
    {
        $class_ids = SchoolClass::where('school_id', $school_id)->pluck('id')->toArray();
        
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($queryParams)) {
            $classes = SchoolClass::where('school_id', $school_id);
            foreach($queryParams as $attr => $parameter){
                $classes->where($attr, $parameter);
            }
            $class_ids = $classes->pluck('id')->toArray();
            $data = TeacherSchedule::whereIn('school_class_id', $class_ids);
        }else{
            $data = TeacherSchedule::whereIn('school_class_id', $class_ids);
        }
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;


        $filterData = SchoolClassResource::collection($data->paginate($perPage));
        return response()->json([
            'teacherSchedules' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);

    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById($teacher_schedule_id)
    {
        $teacherSchedule = TeacherSchedule::findOrFail($teacher_schedule_id);
        $groupedData = $teacherSchedule->schedule_data->groupBy('day_id');
        $formattedData = $groupedData->map(function ($dayData, $dayId) {
            return [
                'day_id' => $dayId,
                'day' => $dayData->first()->day_name->name,
                'data' => $dayData->map(function ($entry) {
                    return [
                        'subject_id' => $entry->subject_id,
                        'subject' => $entry->subject->name,
                        'teacher_id' => $entry->teacher_id,
                        'teacher' => $entry->teacher->name,
                        'period_id' => $entry->period_id,
                        'period' => $entry->period->name,
                    ];
                })->values()
            ];
        })->values();
        return response()->json(['teacherSchedule' => $formattedData, 'message' => trans('api.supervison details')]);
    }

    


    /* this method will stord data to DB Model*/
    public function store(TeacherScheduleStoreRequest $request)
    {
        $teacher_schedul = TeacherSchedule::findOrFail($request->teacher_schedual_id);
        // $teacher_schedul = TeacherSchedule::create([
        //     'school_id' => $request->school_id,
        //     'semester_id' => $request->semester_id,
        //     'school_class_id' => $request->school_class_id,
        // ]);

        foreach ($request->data as $data_per_day) {
            foreach ($data_per_day['data'] as $new_record) {
                TeacherScheduleData::create([
                    'teacher_schedule_id' => $request->teacher_schedual_id,
                    'subject_id' => $new_record['subject_id'],
                    'school_employee_id' => $new_record['school_employee_id'],
                    'day_id' => $data_per_day['day_id'],
                    'period_id' => $new_record['period_id'],
                ]);
            }
        }
        // ------------------------------- School ID -----------------------
        $school_id = $teacher_schedul->school_id;
        $this->ManagerlogActivity('TeacherScheduleData', 'store', $school_id, '/tables/teacher-schedules/'. $request->teacher_schedual_id);

        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(TeacherScheduleUpdateRequest $request, $id)
    {
        $teacher_schedul = TeacherSchedule::findOrFail($id);

        TeacherScheduleData::where('teacher_schedule_id', $id)->delete();

        foreach ($request->data as $data_per_day) {
            foreach ($data_per_day['data'] as $new_record) {
                TeacherScheduleData::create([
                    'teacher_schedule_id' => $id,
                    'subject_id' => $new_record['subject_id'],
                    'school_employee_id' => $new_record['school_employee_id'],
                    'day_id' => $data_per_day['day_id'],
                    'period_id' => $new_record['period_id'],
                ]);
            }
        }
        // ------------------------------- School ID -----------------------
        $school_id = $teacher_schedul->school_id;
        $this->ManagerlogActivity('TeacherScheduleData', 'update', $school_id, '/tables/teacher-schedules/' . $id);

        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id)
    {
        $teacher_schedul = TeacherSchedule::findOrFail($id);
        $school_id = $teacher_schedul->school_id;
        $teacher_schedul->forceDelete();
        // ------------------------------- School ID -----------------------
        $this->ManagerlogActivity('TeacherScheduleData', 'delete', $school_id);
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
