<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Supervision;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Http\Requests\ManagerDashboard\Supervision\SupervisionStoreRequest;
use App\Http\Requests\ManagerDashboard\Supervision\SupervisionUpdateRequest;
use App\Http\Resources\ManagerDashboard\Supervision\SupervisionResource;
use App\Models\ManagerDashboard\SupervisionSchedul;
use App\Models\ManagerDashboard\Supervisor;
use App\Traits\LogsActivity;

class SupervisionController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:supervisions']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request)
    {
        $data = SupervisionSchedul::with('supervisors')->where('school_id',$request->school_id);
        // Retrieve all query parameters
        $perPage = $request->per_page ?? 15;
        $filterData = SupervisionResource::collection($data->paginate($perPage));
        return response()->json([
            'supervision_schedul' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById($id)
    {
        $supervision = SupervisionSchedul::findOrFail($id);
        $groupedData = $supervision->supervisors->groupBy('day_id');
        $formattedData = $groupedData->map(function ($dayData, $dayId) {
            return [
                'day_id' => $dayId,
                'day' => $dayData->first()->day_name->name,
                'data' => $dayData->groupBy('floor_id')->map(function ($floorData, $floorId) {
                    return [
                        'floor_id' => $floorId,
                        'floor' => $floorData->first()->floor_name->name,
                        'supervisors' => $floorData->map(function ($entry) {
                            return [
                                'id' => $entry->id,
                                'school_employee_id' => $entry->school_employee_id,
                                'school_employee' => $entry->employee->name
                            ];
                        })->values()
                    ];
                })->values()
            ];
        })->values();
        return response()->json(['supervison' => $formattedData, 'message' => trans('api.supervison details')]);
    }

    /* this method will stord data to DB Model*/
    public function store(SupervisionStoreRequest $request)
    {
        // $supervision_schedul = SupervisionSchedul::create([
        //     'title' => $request->title,
        //     'school_id' => $request->school_id,
        //     'semester_id' => $request->semester_id
        // ]);
        $supervision_schedul = SupervisionSchedul::findOrFail($request->supervision_schedule_id);
        foreach ($request->data as $data_per_day) {
            foreach ($data_per_day['data'] as $data_per_floor) {
                $school_employee_ids = is_array($data_per_floor['school_employee_id']) ? $data_per_floor['school_employee_id'] : [$data_per_floor['school_employee_id']];
                foreach ($school_employee_ids as $school_employee_id) {
                    Supervisor::create([
                        'supervision_schedule_id' => $request->supervision_schedule_id,
                        'school_employee_id' => $school_employee_id,
                        'day_id' => $data_per_day['day_id'],
                        'floor_id' => $data_per_floor['floor_id'],
                    ]);
                }
            }
        }

        // ------------------------------- School ID -----------------------
        $school_id = $supervision_schedul->school_id;
        $this->ManagerlogActivity('Supervisor', 'store', $school_id, '/tables/supervision-schedules/' . $request->supervision_schedule_id);

        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(SupervisionUpdateRequest $request, $id)
    {
        $supervision_schedul = SupervisionSchedul::findOrFail($id);
        $supervision_schedul->update([
            'title' => $request->title
        ]);
        Supervisor::where('supervision_schedule_id', $id)->delete();

        foreach ($request->data as $data_per_day) {
            foreach ($data_per_day['data'] as $data_per_floor) {
                $school_employee_ids = is_array($data_per_floor['school_employee_id']) ? $data_per_floor['school_employee_id'] : [$data_per_floor['school_employee_id']];
                foreach ($school_employee_ids as $school_employee_id) {
                    Supervisor::Create(
                        [
                            'supervision_schedule_id' => $id,
                            'day_id' => $data_per_day['day_id'],
                            'floor_id' => $data_per_floor['floor_id'],
                            'school_employee_id' => $school_employee_id,
                        ]
                    );
                }
            }
        }
        // ------------------------------- School ID -----------------------
        $school_id = $supervision_schedul->school_id;
        $this->ManagerlogActivity('Supervisor', 'update', $school_id, '/tables/supervision-schedules/' . $id);

        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id)
    {  
        $SupervisionSchedul = SupervisionSchedul::findOrFail($id);
        $school_id = $SupervisionSchedul->school_id;
        $SupervisionSchedul->forceDelete();
        $this->ManagerlogActivity('Supervisor', 'delete', $school_id);
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id)
    {
        $SupervisionSchedul = SupervisionSchedul::findOrFail($id);
        $school_id = $SupervisionSchedul->school_id;
        $SupervisionSchedul->delete();
        $this->ManagerlogActivity('Supervisor', 'archive', $school_id);

        return response()->json(['message' => trans('api.record archived successflly')]);
    }
    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id)
    {
        $SupervisionSchedul = SupervisionSchedul::findOrFail($id);
        $school_id = $SupervisionSchedul->school_id;
        $SupervisionSchedul->restore();
        $this->ManagerlogActivity('Supervisor', 'restore', $school_id);
        return response()->json(['message' => trans('api.record restored successflly')]);
    }
}
