<?php

namespace App\Http\Controllers\Api\ManagerDashboard\LetterAndAlart;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\LettersAndAlarts\StoreLetterRequest;
use App\Http\Requests\ManagerDashboard\LettersAndAlarts\UpdateLetterRequest;
use App\Http\Resources\ManagerDashboard\LetterAndAlart\AlertResource;
use App\Http\Resources\ManagerDashboard\LetterAndAlart\LetterResource;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use App\Models\ManagerDashboard\OfficialSpeeches\Letter;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;

class LetterController extends Controller
{
    use LogsActivity;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:letters']);
    }

    public function index()
    {
       $officialLetter = LetterResource::collection(Letter::where('type','official')->get());
       $warningLetter  = LetterResource::collection(Letter::where('type','warning')->get());
       $verbalAlerts   = AlertResource::collection(Alert::with('employee')->where('type','verbal')->get());
       $writtenAlerts  = AlertResource::collection(Alert::with('employee')->where('type','written')->get());
       return response()->json([
        'officialLetter' => $officialLetter,
        'warningLetter' => $warningLetter,
        'verbalAlerts' => $verbalAlerts,
        'writtenAlerts' => $writtenAlerts,
        'message' => trans('api.list of all available records'),
    ]);
    }


    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request)
    {
     
              // Start with the base query
        $data = Letter::query();

              // Retrieve all query parameters
        $queryParams = $request->query();

        // Filter data is directly from query parameters, excluding `per_page`
        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'per_page';
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\OfficialSpeeches\Letter', $filterData);
        }
        
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = LetterResource::collection($data->paginate($perPage));
      

        return response()->json([
            'letters' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreLetterRequest $request)
    {
        $data = $request->validated();
        $data['date'] = \Carbon\Carbon::createFromFormat('d/m/Y', $data['date'])->format('d/m/Y');

        $Letter = new Letter();
        $Letter->fill($data);
        $Letter->save();
        // ------------------------------- School ID -----------------------
        $school_id =  $data['school_id']; //$request->school_id;
        $this->ManagerlogActivity('Letter', 'store', $school_id, '/officialLetters/letters/' . $Letter->id . '/details');

       
        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    /**
     * Display the specified resource.
     */
    public function getById(Letter $letter)
    {

        $letter = new LetterResource($letter);
        return response()->json(['letter' => $letter], 200);

    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateLetterRequest $request, Letter $letter)
    {

        $validatedData = $request->validated();
        $letter->update($validatedData);
        $school_id = $validatedData['school_id']; //$letter->school_id;
        $this->ManagerlogActivity('Letter', 'update', $school_id, '/officialLetters/letters/' . $letter->id . '/details');

        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }
    /**
     * soft Delete the specified resource from storage.
     */
    public function archive(Letter $letter)
    {
        $school_id = 1; //$letter->school_id;
        $letter->delete();
        $this->ManagerlogActivity('Letter', 'archive', $school_id);

        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Letter $letter)
    {
        $school_id = 1; //$letter->school_id;
        $letter->forceDelete();
        $this->ManagerlogActivity('Letter', 'delete', $school_id);
        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }
    /**
     * restore the specified resource from storage.
     */
    public function restore(Letter $letter)
    {
        $school_id = 1; //$letter->school_id;
        $letter->restore();
        $this->ManagerlogActivity('Letter', 'restore', $school_id);
        return response()->json(['message' => trans('api.record restored successflly')], 200);
    }
}
