<?php

namespace App\Http\Controllers\Api\ManagerDashboard\ClassRoomVisit;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\ClassRoomVisit\StoreClassRoomVisitRequest;
use App\Http\Requests\ManagerDashboard\ClassRoomVisit\UpdateClassRoomVisitRequest;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassRoomvisitResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassvisitCardResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassVisitNeedResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassVisitRateResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassVisitRecommendationResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\VisitMethodResource;
use App\Models\AdminDashboard\School\Period;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitCard;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitNeed;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRate;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRecommendation;
use App\Models\ManagerDashboard\ClassRoomVisits\VisitMethod;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ClassRoomVisitController extends Controller
{
    use LogsActivity;
    /**
     * Display a listing of the resource.
     */
    public function index(School $school)
    {

        $semesters = SchoolSemester::all();
        $response = $semesters->map(function ($semester) use ($school) {
            $ClassRoomVisits = ClassRoomvisitResource::collection(ClassRoomVisitSession::where('school_id',$school->id)->where('semester_id', $semester->id)->get());
            return [
                'school_id' => $school->id,
                'semester_id' => $semester->id,
                'semester_name' => $semester->name,
                'ClassRoomVisits' => $ClassRoomVisits,
            ];
        })->values()->all();

        return response()->json(['data' => $response], 200);
    }
    /**
     * Display the specified resource.
     */
    public function getSemester(School $school , SchoolSemester $semester)
    {
        $ClassRoomVisits = ClassRoomvisitResource::collection(ClassRoomVisitSession::where('school_id',$school->id)->where('semester_id', $semester->id)->get());

        return response()->json(['ClassRoomVisits' => $ClassRoomVisits], 200);
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreClassRoomVisitRequest $request)
    {

        $data = $request->validated();
        $data['date'] = \Carbon\Carbon::createFromFormat('d/m/Y', $data['date'])->format('d/m/Y');

        $classRoomVisit = new ClassRoomVisitSession();
        $classRoomVisit->fill($data);
        $classRoomVisit->save();
        // ------------------------------- School ID -----------------------
        $school_id = $request->school_id;
        $this->ManagerlogActivity('ClassRoomVisitSession', 'store', $school_id, '/classRoomVisits/get-all');

        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    // public static function classes()
    // {
    //     $classes = SchoolClass::select('class_name_id', DB::raw('MIN(school_classes.id) as school_class_id'), 'class_names.name')
    //     ->join('class_names', 'school_classes.class_name_id', '=', 'class_names.id')
    //     ->groupBy('class_name_id', 'class_names.name')
    //     ->get();


    //     return response()->json(['classes' => $classes]);
    // }
    public function getPeriods()
    {
        $periods = Period::select('id','name')->get();
        return response()->json(['periods' => $periods], 200);
    }

    public static function getClassNumber($schoolId ,$id)
    {

        $class = SchoolClass::where('class_name_id',$id)->first();
    
        if (!$class) {
            return response()->json(['error' => 'Class not found'], 404);
        }

        $classNumbers = SchoolClass::select('id','class_number')
        ->where('school_id',$schoolId)->where('class_name_id', $class->class_name_id) // Corrected to use class_name_id
        ->get();

        return response()->json(['classNumbers' => $classNumbers], 200);
    }


    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateClassRoomVisitRequest $request, ClassRoomVisitSession $classRoomVisit)
    {
        $data = $request->validated();

        if (isset($data['date'])) {
            $data['date'] = \Carbon\Carbon::createFromFormat('d/m/Y', $data['date'])->format('d/m/Y');
        }

        $classRoomVisit->update($data);
        // ------------------------------- School ID -----------------------
        $school_id = $classRoomVisit->school_id;
        $this->ManagerlogActivity('ClassRoomVisitSession', 'update', $school_id, '/classRoomVisits/get-all');


        return response()->json(['message' => trans('api.record updated successfully')], 200);
    }
    /**
     * soft Delete the specified resource from storage.
     */
    public function archive(ClassRoomVisitSession $classRoomVisit)
    {
        $school_id = $classRoomVisit->school_id;
        $classRoomVisit->delete();
        $this->ManagerlogActivity('ClassRoomVisitSession', 'archive', $school_id);
        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }
    /**
     * restore the specified resource from storage.
     */
    public function restore(ClassRoomVisitSession $classRoomVisit)
    {
        $school_id = $classRoomVisit->school_id;
        $classRoomVisit->restore();
        $this->ManagerlogActivity('ClassRoomVisitSession', 'restore', $school_id);
        return response()->json(['message' => trans('api.record restored successflly')], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ClassRoomVisitSession $classRoomVisit)
    {
        $school_id = $classRoomVisit->school_id;
        $classRoomVisit->forceDelete();
        $this->ManagerlogActivity('ClassRoomVisitSession', 'delete', $school_id);
        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }


    // for get class visit rate 

    public function getRating(ClassRoomVisitSession $classRoomVisit)
    {
            // Retrieve the class visit card
        $classVisitCard = ClassVisitCard::where('classVisit_id', $classRoomVisit->id)->firstOrFail();
         // Retrieve the class visit rate
         $classVisitRate = ClassVisitRate::where('classVisit_id', $classRoomVisit->id)->firstOrFail();
          
         // Retrieve the class visit recommendation
         $classVisitRecommendation = ClassVisitRecommendation::where('classVisit_id', $classRoomVisit->id)->firstOrFail();
 
         // Retrieve the class visit needs
         $classVisitNeeds = ClassVisitNeed::where('classVisit_id', $classRoomVisit->id)->get();
 
         return response()->json([
            'class_visit_card'=>  new ClassvisitCardResource($classVisitCard),
            'class_visit_rate' => new ClassVisitRateResource($classVisitRate),
            'class_visit_recommendation' => new ClassVisitRecommendationResource($classVisitRecommendation),
            'class_visit_needs' =>  ClassVisitNeedResource::collection($classVisitNeeds),
         ]);
    }

    public function getVisitMethods()
    {
        $visitMethods = VisitMethodResource::collection (VisitMethod::get());
        return response()->json(['visitMethods' => $visitMethods], 200);
    }

    
}
