<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Assignments;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Assignments\GeneralAssignmentRequest;
use App\Models\ManagerDashboard\Assignments\GeneralAssignment;
use App\Models\ManagerDashboard\Assignments\GeneralAssignmentEmployee;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GeneralAssignmentController extends Controller
{
   
    /**
     * Store a newly created resource in storage.
     */
    public function store(GeneralAssignmentRequest $request)
    {

        $data = $request->validated();

        $employeeIds = $data['employees'];

        unset($data['employees']);

        $generalAssignment  = GeneralAssignment::create($data);

        foreach ($employeeIds as $employeeId) {
            GeneralAssignmentEmployee::create([
                'general_assignment_id' => $generalAssignment->id,
                'employee_id' => $employeeId
            ]);
        }

        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }



    /**
     * Soft Delete.
     */
    public function archive(GeneralAssignment $assignment)
    {

        DB::beginTransaction();

        try {

            $assignment->delete();

            GeneralAssignmentEmployee::where('general_assignment_id', $assignment->id)->delete();


            // Commit the transaction if everything is successful
            DB::commit();

            return response()->json(['message' => trans('api.record archived successfully')]);
        } catch (\Exception $e) {
            // Rollback the transaction if any error occurs
            DB::rollBack();

            return response()->json(['error' => trans('api.failed_to_archive_record')], 500);
        }
    }



    /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(GeneralAssignment $assignment)
    {

        $assignment->restore();

        GeneralAssignmentEmployee::where('general_assignment_id', $assignment->id)->restore();

        return response()->json(['message' => trans('api.record restored successflly')]);
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(GeneralAssignment $assignment)
    {

        $assignment->forceDelete();

        GeneralAssignmentEmployee::where('general_assignment_id', $assignment->id)->forceDelete();

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
