<?php
namespace App\Http\Controllers\Api\AdminDashboard\Violation;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Http\Requests\Violation\ViolationStoreRequest;
use App\Http\Requests\Violation\ViolationUpdateRequest;
use App\Http\Resources\Violation\GradeViolationResource;
use App\Models\Violation;
use App\Http\Resources\Violation\ViolationResource;
use App\Models\GradeViolation;
use App\Models\ViolationName;
use App\Traits\LogsActivity;

class ViolationController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:violations']);
    }

    public function getNames(){
        return ViolationName::all();
    }

    /*
        -this method will return all Model recoreds
    */
    // public function getAll($school_grade_id, Request $request){
    //     $violations =ViolationResource::collection(Violation::with('violation_grades')->where('school_grade_id', $school_grade_id)->paginate($request->per_page));
    //     return response()->json(['violations'=>$violations,'message'=>trans('api.list of all available records') ]);
    // }
    public function getAll($school_grade_id, Request $request)
    {
        // Start with the base query
        $data = Violation::with('violation_grades')->where('school_grade_id', $school_grade_id);

        // Retrieve all query parameters
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\Violation', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = ViolationResource::collection($data->paginate($perPage));


        return response()->json([
            'violations' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById($violation_grade_id,Request $request){
        $grade_violation = GradeViolation::findOrFail($violation_grade_id);
        $grade_violation_resource = new GradeViolationResource($grade_violation);
        return response()->json(['grade_violations'=> $grade_violation_resource,'message'=>trans('api.Violation details') ]);    
    }

    /* this method will stord data to DB Model*/
    public function store(ViolationstoreRequest $request){
        Violation::create($request->all());
        $this->AdminlogActivity('Violation', 'store', '/violations/violations/get-all/'. $request->school_grade_id);
        return response()->json(['message'=>trans('api.record stored successflly') ]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(ViolationUpdateRequest $request,$id){
        $violation = Violation::findOrFail($id);
        $violation->update($request->all());
        $this->AdminlogActivity('Violation', 'update', '/violations/violations/get-all/' . $violation->school_grade_id);
        return response()->json(['message'=>trans('api.record updated successflly') ]);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id){
        Violation::findOrFail($id)->delete();
        $this->AdminlogActivity('Violation', 'archive');
        return response()->json(['message'=>trans('api.record archived successflly') ]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id){
        Violation::findOrFail($id)->forceDelete();
        $this->AdminlogActivity('Violation', 'delete');
        return response()->json(['message'=>trans('api.record deleted successflly') ]);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id){
        Violation::withTrashed()->findOrFail($id)->restore();
        $this->AdminlogActivity('Violation', 'restore');
        return response()->json(['message'=>trans('api.record restored successflly') ]);
    }
    
}